// Autor: Gustav Matula

#include <cstdio>
#include <cstring>

#include <vector>
#include <iostream>
#include <algorithm>

using namespace std;
typedef long long llint;
const llint inf = 1000000000000000000LL;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

typedef pair< llint, llint > Cell;

const int MAXN = 200005;

llint miny[MAXN], maxy[MAXN];

int main(void) 
{
  int N;
  scanf("%d", &N);

  vector< Cell > e;

  REP(i, N) {
    int x, y;
    scanf("%d%d", &x, &y); --x; --y;
    e.push_back({x, y});
  }

  sort(e.begin(), e.end());

  miny[N] = inf;
  maxy[N] = 0;

  for (int i = N - 1; i >= 0; --i) {
    miny[i] = min(miny[i + 1], e[i].second);
    maxy[i] = max(maxy[i + 1], e[i].second);
  }

  llint cminy = inf;
  llint cmaxy = 0;
  llint sol = 0;

  for (int i = 0, j; i < N; i = j) {
    for (j = i + 1; j < N && e[j].first == e[i].first; ++j);

    llint lo = max(cminy, miny[j]);
    llint hi = min(cmaxy, maxy[j]);
    if (hi - lo - 1 >= 1) 
      sol += hi - lo - 1;

    FOR(k, i, j) {
      cminy = min(cminy, e[k].second);
      cmaxy = max(cmaxy, e[k].second);
    }

    lo = max(cminy, miny[j]);
    hi = min(cmaxy, maxy[j]);
    if (hi - lo - 1 >= 1)
      sol += (llint)(e[j].first - e[i].first - 1) * (hi - lo - 1);
  }

  printf("%lld\n", sol);

  return 0;
}
